unit UnitSmpp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, UnitSmppOptions,
  Dialogs, ComCtrls, StdCtrls, UnitSendOptions, AXmsCtrl_TLB, ExtCtrls, ShellAPI, UnitRingtone, UnitPicture, UnitWap;

type
  TFormSmpp = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    ButtonConnect: TButton;
    ButtonDisconnect: TButton;
    EditServer: TEdit;
    EditSystemID: TEdit;
    EditSystemPassword: TEdit;
    EditServerPort: TEdit;
    ComboSystemMode: TComboBox;
    GroupBox2: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    EditRecipient: TEdit;
    ButtonSend: TButton;
    ButtonOptions: TButton;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    ListView1: TListView;
    ListView2: TListView;
    ButtonClearTX: TButton;
    ButtonClearRX: TButton;
    GroupBox5: TGroupBox;
    Label8: TLabel;
    Label9: TLabel;
    EditResult: TEdit;
    EditLogfile: TEdit;
    ButtonView: TButton;
    Timer: TTimer;
    ButtonAdvanced: TButton;
    EditMessage: TMemo;
    ButtonWap: TButton;
    ButtonRingtone: TButton;
    ButtonPicture: TButton;
    function GetTempDirectory ()  : String;
    function GetResult ()         : Integer;
    procedure Receive ();
    procedure Query ();
    procedure EnableControls ();
    procedure LoadDefaults ();
    procedure FormCreate(Sender: TObject);
    procedure ButtonConnectClick(Sender: TObject);
    procedure ButtonDisconnectClick(Sender: TObject);
    procedure ButtonSendClick(Sender: TObject);
    procedure ButtonOptionsClick(Sender: TObject);
    procedure ButtonViewClick(Sender: TObject);
    procedure ButtonClearTXClick(Sender: TObject);
    procedure ButtonClearRXClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure ButtonAdvancedClick(Sender: TObject);
    procedure ButtonWapClick(Sender: TObject);
    procedure ButtonRingtoneClick(Sender: TObject);
    procedure ButtonPictureClick(Sender: TObject);
  private
    bConnected            : Boolean;
    bUnicode              : Boolean;
    bMultipart            : Boolean;
    bFlash                : Boolean;
    bUDH                  : Boolean;

    bSender               : Boolean;
    bReceiver             : Boolean;

    SystemSourceNPI       : Integer;
    SystemSourceTON       : Integer;
    SystemDestinationNPI  : Integer;
    SystemDestinationTON  : Integer;
    SystemVersion         : Integer;
    ServerTimeout         : Integer;
    ServerKeepAlive       : Integer;
    SystemThroughput      : Integer;
    SystemCharset         : Integer;

    SystemSourceAddress   : String;
    AddressRange          : String;

    objSmpp               : ISmsProtocolSmpp;
    objConstants          : ISmsConstants;
    objMessage            : ISmsMessage;

  public
    { Public declarations }
  end;

var
  FormSmpp: TFormSmpp;

implementation

{$R *.dfm}

{////////////////////////////////////////////////////////////////////////////////}

function TFormSmpp.GetTempDirectory () : String;
var Buffer : array [0..MAX_PATH] of Char;
begin
  GetTempPath ( MAX_PATH, Buffer );
  EditLogfile.Text := StrPas ( Buffer ) + 'SmppLog.txt';
end;

{////////////////////////////////////////////////////////////////////////////////}

function TFormSmpp.GetResult () : Integer;
begin
  Result := objSmpp.LastError;

  EditResult.Text := IntToStr ( Result ) + ' : ' + objSmpp.GetErrorDescription( Result );
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.FormCreate(Sender: TObject);
begin
  objSmpp       := TSmsProtocolSmpp.Create ( Application ).DefaultInterface;
  objConstants  := TSmsConstants.Create(Application).DefaultInterface;
  objMessage    := TSmsMessage.Create(Application).DefaultInterface;

  ComboSystemMode.Items.Add ( 'Transceiver' );
  ComboSystemMode.Items.Add ( 'Transmitter' );
  ComboSystemMode.Items.Add ( 'Receiver' );

  ComboSystemMode.ItemIndex := 0;

  GetTempDirectory ();

  EnableControls ();

  LoadDefaults ();
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.LoadDefaults ();
begin
  SystemSourceAddress               := objSmpp.SystemSourceAddress;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.ButtonConnectClick(Sender: TObject);
begin
  objSmpp.LogFile         := EditLogfile.Text;
  objSmpp.Server          := EditServer.Text;
  objSmpp.ServerPort      := StrToInt ( EditServerPort.Text );
  objSmpp.SystemID        := EditSystemID.Text;
  objSmpp.SystemPassword  := EditSystemPassword.Text;
  objSmpp.SystemMode      := ComboSystemMode.ItemIndex;

  objSmpp.Connect;

  case ComboSystemMode.ItemIndex of
  0:  begin bSender := true;  bReceiver := true;  end;
  1:  begin bSender := true;  bReceiver := false; end;
  2:  begin bSender := false; bReceiver := true;  end;
  end;

  GetResult ();

  EnableControls ();
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.ButtonDisconnectClick(Sender: TObject);
begin
  objSmpp.Disconnect;

  EnableControls ();
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.ButtonSendClick(Sender: TObject);
var
  Item : TListItem;
  strReference : String;
  vtVar : OleVariant;
begin
  if objSmpp.IsConnected = -1 then
  begin
    objMessage.Data := EditMessage.Text;
    objMessage.Recipient := EditRecipient.Text;

    if ( bUnicode = true ) then
    begin
      if ( bMultipart = true ) then
      begin
        objMessage.Format := objConstants.asMESSAGEFORMAT_UNICODE_MULTIPART;
      end
      else
      begin
        objMessage.Format := objConstants.asMESSAGEFORMAT_UNICODE;
      end;
      if ( bFlash = true ) then
      begin
        objMessage.Format := objConstants.asMESSAGEFORMAT_UNICODE_FLASH;
      end;
    end
    else
    begin
      if ( bMultipart = true ) then
      begin
        objMessage.Format := objConstants.asMESSAGEFORMAT_TEXT_MULTIPART;
      end
      else
      begin
        objMessage.Format := objConstants.asMESSAGEFORMAT_TEXT;
      end;
      if ( bFlash = true ) then
      begin
        objMessage.Format := objConstants.asMESSAGEFORMAT_TEXT_FLASH;
      end;
    end;

    vtVar := objMessage;
    strReference := objSmpp.Send ( vtVar );

    if GetResult = 0 Then
    begin
      Item := ListView1.Items.Add;
      Item.Caption := strReference;
      Item.SubItems.Add ( objMessage.Recipient );
      Item.SubItems.Add ( 'n/a' );
      Item.SubItems.Add ( 'Submitted' );
    end;
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.ButtonOptionsClick(Sender: TObject);
begin
  FormSendOptions.CheckMultipart.Checked  := bMultipart;
  FormSendOptions.CheckFlash.Checked      := bFlash;
  FormSendOptions.CheckUnicode.Checked    := bUnicode;
  FormSendOptions.CheckUDH.Checked        := bUDH;

  if FormSendOptions.ShowModal = mrOK then begin
    bMultipart  := FormSendOptions.CheckMultipart.Checked;
    bFlash      := FormSendOptions.CheckFlash.Checked;
    bUDH        := FormSendOptions.CheckUDH.Checked;
    bUnicode    := FormSendOptions.CheckUnicode.Checked;
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.EnableControls ();
begin
  if ( objSmpp.IsConnected = -1 ) Then
    bConnected := true
  else
    bConnected := false;

  ButtonConnect.Enabled       := Not bConnected;
  ButtonAdvanced.Enabled      := Not bConnected;
  EditServer.Enabled          := Not bConnected;
  EditServerPort.Enabled      := Not bConnected;
  EditSystemID.Enabled        := Not bConnected;
  EditSystemPassword.Enabled  := Not bConnected;
  ComboSystemMode.Enabled     := Not bConnected;

  ButtonDisconnect.Enabled    := bConnected;

  ButtonSend.Enabled          := bConnected And bSender;
  EditRecipient.Enabled       := bConnected And bSender;
  EditMessage.Enabled         := bConnected And bSender;
  ButtonWap.Enabled           := bConnected And bSender;
  ButtonPicture.Enabled       := bConnected And bSender;
  ButtonRingtone.Enabled      := bConnected And bSender;
  ButtonClearTX.Enabled       := bConnected And bSender;
  ButtonOptions.Enabled       := bConnected And bSender;
  ListView1.Enabled           := bConnected And bSender;

  ButtonClearRX.Enabled       := bConnected And bReceiver;
  ListView2.Enabled           := bConnected And bReceiver;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSMpp.ButtonViewClick(Sender: TObject);
var LogFile : PAnsiChar;
begin
  LogFile := StrNew(PChar(EditLogfile.Text));

  ShellExecute ( 0, 'open' , LogFile, '', '', SW_SHOW )
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.ButtonClearTXClick(Sender: TObject);
begin
  ListView1.Items.Clear;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.ButtonClearRXClick(Sender: TObject);
begin
  ListView2.Items.Clear;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.TimerTimer(Sender: TObject);
begin
  if ( objSmpp.IsConnected = -1 ) Then begin
    Query ();
    Receive ();
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.ButtonAdvancedClick(Sender: TObject);
begin
  FormSmppOptions.SystemSourceNPI       := SystemSourceNPI;
  FormSmppOptions.SystemSourceTON       := SystemSourceTON;
  FormSmppOptions.SystemDestinationNPI  := SystemDestinationNPI;
  FormSmppOptions.SystemDestinationTON  := SystemDestinationTON;
  FormSmppOptions.SystemSourceAddress   := SystemSourceAddress;
  FormSmppOptions.SystemVersion         := SystemVersion;
  FormSmppOptions.SystemThroughput      := SystemThroughput;
  FormSmppOptions.SystemCharset         := SystemCharset;
  FormSmppOptions.ServerTimeout         := ServerTimeout;
  FormSmppOptions.ServerKeepAlive       := ServerKeepAlive;
  FormSmppOptions.AddressRange          := AddressRange;

  if ( FormSmppOptions.ShowModal () = mrOK ) then begin
    SystemSourceNPI                     := FormSmppOptions.SystemSourceNPI;
    SystemSourceTON                     := FormSmppOptions.SystemSourceTON;
    SystemDestinationNPI                := FormSmppOptions.SystemDestinationNPI;
    SystemDestinationTON                := FormSmppOptions.SystemDestinationTON;
    SystemSourceAddress                 := FormSmppOptions.SystemSourceAddress;
    SystemVersion                       := FormSmppOptions.SystemVersion;
    SystemThroughput                    := FormSmppOptions.SystemThroughput;
    SystemCharset                       := FormSmppOptions.SystemCharset;
    ServerTimeout                       := FormSmppOptions.ServerTimeout;
    ServerKeepAlive                     := FormSmppOptions.ServerKeepAlive;
    AddressRange                        := FormSmppOptions.AddressRange;
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.ButtonWapClick(Sender: TObject);
begin
  if ( FormWap.ShowModal = mrOK ) then begin
    EditMessage.Text := FormWap.strMessage;

    bMultipart      := false;
    bUnicode        := false;
    bFlash          := false;
    bUDH            := false;
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.ButtonRingtoneClick(Sender: TObject);
begin
  if ( FormRingtone.ShowModal = mrOK ) then begin
    EditMessage.Text := FormRingtone.strMessage;

    bMultipart      := false;
    bUnicode        := false;
    bFlash          := false;
    bUDH            := false;
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.ButtonPictureClick(Sender: TObject);
begin
  if ( FormPicture.ShowModal = mrOK ) then begin
    EditMessage.Text := FormPicture.strMessage;

    bMultipart      := false;
    bUnicode        := false;
    bFlash          := false;
    bUDH            := false;
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.Receive ();
var
  Item : TListItem;
  Msg  : ISmsMessage;
  vtVar : OleVariant;
begin
  vtVar := objSmpp.GetFirstMessage ();

  while ( objSmpp.LastError = 0 ) do  begin
    Msg := IDispatch ( vtVar ) as ISmsMessage;

    Item := ListView2.Items.Add;

    Item.Caption := Msg.Sender;

    Item.SubItems.Add ( Msg.Time );
    Item.SubItems.Add ( Msg.Data );

    vtVar := objSmpp.GetNextMessage ();
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmpp.Query ();
var
  n            : Integer;
  nCount       : Integer;
  Item         : TListItem;
  Status       : ISmsDeliveryStatus;
  vtVar        : OleVariant;
begin

  nCount    := ListView1.Items.Count;

  for n := 1 to nCount do begin
    Item := ListView1.Items.Item [ n - 1 ];

    if ( Item.SubItems.Strings [ 1 ] = 'n/a' ) then begin

      vtVar := objSmpp.QueryStatus ( Item.Caption );
      Status := IDispatch ( vtVar ) as ISmsDeliveryStatus;
      
      if ( objSmpp.LastError = 0 ) then begin
        Item.SubItems.Strings [ 1 ] := Status.StatusCompletedTime;
        Item.SubItems.Strings [ 2 ] := Status.StatusDescription;
      end;
    end;
  end;
end;

{////////////////////////////////////////////////////////////////////////////////}

end.
